#!/bin/bash
# Quick setup script to install Git hooks in current project

echo "🔧 Setting up Version Control Git Hooks..."
echo ""

# Check if we're in a Git repository
if [ ! -d ".git" ]; then
    echo "❌ Error: Not a Git repository. Please run this from your project root."
    exit 1
fi

# Get the directory where this script is located
SCRIPT_DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"

# Check if hooks exist
if [ ! -f "$SCRIPT_DIR/pre-commit" ]; then
    echo "❌ Error: Hook scripts not found. Make sure you're running from the scripts directory."
    exit 1
fi

# Copy hooks
echo "📋 Copying hooks to .git/hooks/..."
cp "$SCRIPT_DIR/pre-commit" .git/hooks/pre-commit
cp "$SCRIPT_DIR/commit-msg" .git/hooks/commit-msg
cp "$SCRIPT_DIR/post-merge" .git/hooks/post-merge

# Make them executable
echo "🔐 Making hooks executable..."
chmod +x .git/hooks/pre-commit
chmod +x .git/hooks/commit-msg
chmod +x .git/hooks/post-merge

echo ""
echo "✅ Git hooks installed successfully!"
echo ""
echo "Installed hooks:"
echo "  ✓ pre-commit   - Blocks console/print statements, checks formatting"
echo "  ✓ commit-msg   - Validates commit messages (3+ words)"
echo "  ✓ post-merge   - Runs linter after merging"
echo ""
echo "To bypass hooks temporarily, use: git commit --no-verify"
echo ""
