# Branching Conventions

## Branch Types and Naming

### Feature Branches
- **Pattern**: `feature/<feature-name>`
- **Purpose**: New features or enhancements
- **Examples**:
  - `feature/user-authentication`
  - `feature/payment-gateway`
  - `feature/dashboard-redesign`
- **Lifecycle**: Created from `dev`, merged back to `dev`

### Bug Fix Branches
- **Pattern**: `bugfix/<bug-description>` or `fix/<bug-description>`
- **Purpose**: Bug fixes and corrections
- **Examples**:
  - `bugfix/login-validation`
  - `fix/null-reference-error`
  - `bugfix/api-timeout`
- **Lifecycle**: Created from `dev` or `master` (for hotfixes), merged back to source

### Environment Branches
- **`master`**: Production-ready code, stable releases only
- **`stage`**: Staging/pre-production environment, final testing before production
- **`dev`**: Development branch, integration of features

### Additional Branch Types
- **Hotfix**: `hotfix/<critical-fix>` - Emergency fixes for production
- **Release**: `release/<version>` - Preparation for production release

## Workflow

### Standard Feature Development
```
dev → feature/new-feature → dev → stage → master
```

### Bug Fix
```
dev → bugfix/issue-name → dev
```

### Hotfix (Production Emergency)
```
master → hotfix/critical-fix → master + dev
```

## Branch Protection Rules

- **master**: Requires pull request, code review, all checks pass
- **stage**: Requires pull request, testing validation
- **dev**: Direct pushes allowed for small changes, PR recommended for features
